/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.util.Trace;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AppletTask
extends PresentationTask
implements HMCSessionListener {
    private static final String TRACE_MASKT = "XFRMAPTT";
    private static final String TRACE_MASKF = "XFRMAPTF";
    private static final String TRACE_MASKD = "XFRMAPTD";
    private static final String APPLET_START = "<applet archive=\"{0}\" code=\"{1}\" width=\"1\" height=\"1\">";
    private static final String PARAM_TAG = "<param NAME=\"{0}\" VALUE=\"{1}\"/>";
    private static final String APPLET_END = "</applet>";
    private static Set appletPortals = new HashSet();

    private static synchronized void addApplet(PanelModelTaskPortal portal) {
        Trace.trace(TRACE_MASKT, "-> AppletTask.addApplet()");
        appletPortals.add(portal);
        Trace.trace(TRACE_MASKT, "<- AppletTask.addApplet()");
    }

    private static synchronized void removeApplet(PanelModelTaskPortal portal) {
        Trace.trace(TRACE_MASKT, "-> AppletTask.removeApplet()");
        appletPortals.remove(portal);
        if (appletPortals.isEmpty()) {
            String script = "<SCRIPT src=\"/js/applet.js\" type=\"text/javascript\"></SCRIPT><SCRIPT language='JavaScript'>try { reloadAppletManager(); } catch(e) { }</SCRIPT>";
            TaskControllerQueue.getTaskControllerQueue(portal.getHMCSession()).sendRawScript(script, portal);
        }
        Trace.trace(TRACE_MASKT, "<- AppletTask.removeApplet()");
    }

    public AppletTask(PresentationTaskParms parms) throws IllegalArgumentException {
        super(parms);
        Trace.trace(TRACE_MASKT, "<> AppletTask.ctor()");
    }

    public void showApplet(String archive, String code, Map params) {
        Set keys;
        Trace.trace(TRACE_MASKT, "-> AppletTask.showApplet()");
        PanelModelTaskPortal portal = this.getPanelModelTaskPortal();
        StringBuffer appletTag = new StringBuffer();
        appletTag.append(MessageFormat.format(APPLET_START, archive, code));
        if (params != null && (keys = params.keySet()).size() > 0) {
            Object[] subst = new Object[2];
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                subst[0] = i.next();
                subst[1] = params.get(subst[0]);
                appletTag.append(MessageFormat.format(PARAM_TAG, subst));
            }
        }
        appletTag.append(APPLET_END);
        String script = "<SCRIPT src=\"/js/applet.js\" type=\"text/javascript\"></SCRIPT><SCRIPT language='JavaScript'>try { addApplet('" + appletTag + "'); } catch(e) { }</SCRIPT>";
        AppletTask.addApplet(portal);
        TaskControllerQueue.getTaskControllerQueue(this.getHMCSession()).sendRawScript(script, portal);
        this.getHMCSession().taskIsRealized(portal);
        this.getHMCSession().addHMCSessionListener(this);
        Trace.trace(TRACE_MASKT, "<- AppletTask.showApplet()");
    }

    public void sessionDisconnected(HMCSession session) {
    }

    public void sessionConnected(HMCSession session) {
    }

    public void sessionDestroyed(HMCSession session) {
    }

    public void clientConnectivityLost(HMCSession session) {
    }

    public void clientConnectivityGained(HMCSession session) {
    }

    public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
    }

    public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
    }

    public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
        Trace.trace(TRACE_MASKT, "-> AppletTask.taskEnded()");
        if (portal.equals(this.getPanelModelTaskPortal())) {
            AppletTask.removeApplet(portal);
            session.removeHMCSessionListener(this);
        }
        Trace.trace(TRACE_MASKT, "<- AppletTask.taskEnded()");
    }
}

